/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.io.MozFileWriter;
import org.mozilla.translator.io.MozIo;
import org.mozilla.translator.kernel.Log;

public class WriteJarRunner
extends Thread {
    private MozInstall install;
    private String fileName;
    private String localeName;
    private String xlocaleName;
    private String author;
    private String display;
    private String displayRegion;
    private String preview;
    private File zipFile;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private BufferedOutputStream bos;
    private String entryName;

    public WriteJarRunner(MozInstall i, String fn, String ln, String a, String d, String dr, String p) {
        this.install = i;
        this.fileName = fn;
        this.localeName = ln;
        this.xlocaleName = i.getLocaleName(ln);
        this.author = a;
        this.display = d;
        this.displayRegion = dr;
        this.preview = p;
    }

    public void run() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        MozFile currentFile = null;
        int filesDone = 0;
        try {
            this.zipFile = new File(this.fileName);
            this.fos = new FileOutputStream(this.zipFile);
            this.zos = new ZipOutputStream(this.fos);
            this.bos = new BufferedOutputStream(this.zos);
            String zipPrefix = "locale/".concat(String.valueOf(String.valueOf(this.xlocaleName)));
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                String componentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(zipPrefix))).append("/").append(currentComponent.getName())));
                Iterator subcomponentIterator = currentComponent.getChildIterator();
                while (subcomponentIterator.hasNext()) {
                    MozComponent currentSubComponent = (MozComponent)subcomponentIterator.next();
                    String subcomponentPrefix = !currentSubComponent.getName().equals("MT_default") ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(componentPrefix))).append("/").append(currentSubComponent.getName()))) : componentPrefix;
                    Iterator fileIterator = currentSubComponent.getChildIterator();
                    while (fileIterator.hasNext()) {
                        currentFile = (MozFile)fileIterator.next();
                        this.entryName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(subcomponentPrefix))).append("/").append(currentFile.getName())));
                        vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("files done: ").append(filesDone).append(", currently packing: ").append(currentFile))));
                        this.writeFile(currentFile);
                        ++filesDone;
                    }
                }
            }
            this.bos.close();
        }
        catch (Exception e) {
            Log.write("Error writing jar file ".concat(String.valueOf(String.valueOf(currentFile))));
            Log.write("Exception: ".concat(String.valueOf(String.valueOf(e))));
        }
        MainWindow.getDefaultInstance().setStatus("Ready");
    }

    private void writeFile(MozFile fil) throws IOException {
        block3: {
            File temp = File.createTempFile("MT_", null);
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            MozFileWriter writer = MozIo.getFileWriter(fil, fos);
            if (writer == null) break block3;
            writer.writeFile(this.localeName);
            if (fil.getName().equals("contents.rdf")) {
                fos.close();
                long filesize = temp.length();
                StringBuffer rawBuild = new StringBuffer((int)filesize);
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(temp)));
                boolean theEnd = false;
                while (!theEnd) {
                    int number = br.read();
                    if (number == -1) {
                        theEnd = true;
                        continue;
                    }
                    char letter = (char)number;
                    rawBuild.append(letter);
                }
                br.close();
                String s2 = this.convertManifest2(rawBuild.toString());
                fos = new FileOutputStream(temp);
                fos.write(s2.getBytes());
            }
            this.copyFile(temp, this.entryName);
        }
    }

    private String convertManifest2(String s) {
        Pattern p = Pattern.compile("en-US");
        s = p.matcher(s).replaceAll(this.xlocaleName);
        p = Pattern.compile("US");
        s = p.matcher(s).replaceAll(this.xlocaleName);
        p = Pattern.compile("chrome:author=\"[^\"]*\"");
        s = p.matcher(s).replaceAll(String.valueOf(String.valueOf(new StringBuffer("chrome:author=\"").append(this.author).append("\""))));
        p = Pattern.compile("chrome:displayName=\"[^\"]*\"");
        s = !this.install.isRegion() ? p.matcher(s).replaceAll(String.valueOf(String.valueOf(new StringBuffer("chrome:displayName=\"").append(this.display).append("\"")))) : p.matcher(s).replaceAll(String.valueOf(String.valueOf(new StringBuffer("chrome:displayName=\"").append(this.displayRegion).append("\""))));
        p = Pattern.compile("chrome:previewURL=\"[^\"]*\"");
        s = p.matcher(s).replaceAll(String.valueOf(String.valueOf(new StringBuffer("chrome:previewURL=\"").append(this.preview).append("\""))));
        return s;
    }

    private void writeManifest() {
        try {
            Iterator manifestIterator = this.install.getChildIterator();
            while (manifestIterator.hasNext()) {
                MozComponent manifestComponent = (MozComponent)manifestIterator.next();
                File fil = File.createTempFile("MT_", null);
                fil.deleteOnExit();
                FileWriter fw = new FileWriter(fil);
                PrintWriter pw = new PrintWriter(fw);
                pw.println("<?xml version=\"1.0\"?>");
                pw.println("<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
                pw.println("         xmlns:chrome=\"http://www.mozilla.org/rdf/chrome#\">");
                pw.println();
                pw.println("  <!-- list all the skins being supplied by this package -->");
                pw.println("  <RDF:Seq about=\"urn:mozilla:locale:root\">");
                pw.println(String.valueOf(String.valueOf(new StringBuffer("    <RDF:li resource=\"urn:mozilla:locale:").append(this.xlocaleName).append("\"/>"))));
                pw.println("  </RDF:Seq>");
                pw.println();
                pw.println("  <!-- locale information -->");
                pw.println(String.valueOf(String.valueOf(new StringBuffer("<RDF:Description about=\"urn:mozilla:locale:").append(this.xlocaleName).append("\""))));
                if (this.install.isRegion()) {
                    pw.println(String.valueOf(String.valueOf(new StringBuffer("     chrome:displayName=\"").append(this.displayRegion).append("\""))));
                } else {
                    pw.println(String.valueOf(String.valueOf(new StringBuffer("     chrome:displayName=\"").append(this.display).append("\""))));
                }
                pw.println(String.valueOf(String.valueOf(new StringBuffer("     chrome:author=\"").append(this.author).append("\""))));
                pw.println(String.valueOf(String.valueOf(new StringBuffer("     chrome:name=\"").append(this.xlocaleName).append("\""))));
                if (this.install.isRegion()) {
                    pw.println("     chrome:localeType=\"region\"");
                }
                pw.println(String.valueOf(String.valueOf(new StringBuffer("     chrome:previewURL=\"").append(this.preview).append("\">"))));
                pw.println("   <chrome:packages>");
                pw.println(String.valueOf(String.valueOf(new StringBuffer("      <RDF:Seq about=\"urn:mozilla:locale:").append(this.xlocaleName).append(":packages\">"))));
                pw.println(String.valueOf(String.valueOf(new StringBuffer("        <RDF:li resource=\"urn:mozilla:locale:").append(this.xlocaleName).append(":").append(manifestComponent.getName()).append("\"/>"))));
                pw.println("      </RDF:Seq>");
                pw.println("    </chrome:packages>");
                pw.println("  </RDF:Description>");
                pw.println(String.valueOf(String.valueOf(new StringBuffer("  <RDF:Description about=\"urn:mozilla:locale:").append(this.xlocaleName).append(":").append(manifestComponent.getName()).append("\""))));
                pw.println("</RDF:RDF>");
                pw.close();
                String ManiFest = String.valueOf(String.valueOf(new StringBuffer("locale/").append(this.xlocaleName).append("/").append(manifestComponent.getName()).append("/contents.rdf")));
                this.copyFile(fil, ManiFest);
            }
        }
        catch (Exception e) {
            Log.write("Error writing contents file");
            Log.write("Exception :".concat(String.valueOf(String.valueOf(e))));
        }
    }

    private void copyFile(File tempFile, String eName) throws IOException {
        ZipEntry ze = new ZipEntry(eName);
        this.zos.putNextEntry(ze);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            this.bos.write(trans);
        }
        bis.close();
        this.bos.flush();
    }
}

