/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.ComplexTableWindow;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.dialog.ShowWhatDialog;
import org.mozilla.translator.io.MozFileReader;
import org.mozilla.translator.io.MozIo;
import org.mozilla.translator.kernel.Log;

public class UpdateInstallRunner
extends Thread {
    private MozInstall install;
    private List collectedList;

    public UpdateInstallRunner(MozInstall i) {
        this.install = i;
        this.collectedList = new ArrayList();
    }

    public void run() {
        block12: {
            MainWindow vindue = MainWindow.getDefaultInstance();
            String baseName = this.install.getPath();
            File baseFile = new File(baseName);
            if (baseFile.isDirectory()) {
                this.updateFromDirectory();
            } else {
                try {
                    this.updateFromJar();
                }
                catch (Exception e) {
                    Log.write("Exception in updateFromJar() ".concat(String.valueOf(String.valueOf(e))));
                }
            }
            vindue.setStatus("Removing dead phrases");
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                if (currentComponent.isMarked()) {
                    Iterator subComponentIterator = currentComponent.getChildIterator();
                    while (subComponentIterator.hasNext()) {
                        MozComponent currentSubComponent = (MozComponent)subComponentIterator.next();
                        if (currentSubComponent.isMarked()) {
                            Iterator fileIterator = currentSubComponent.getChildIterator();
                            while (fileIterator.hasNext()) {
                                MozFile currentFile = (MozFile)fileIterator.next();
                                if (currentFile.isMarked()) {
                                    Iterator phraseIterator = currentFile.getChildIterator();
                                    while (phraseIterator.hasNext()) {
                                        Phrase currentPhrase = (Phrase)phraseIterator.next();
                                        if (currentPhrase.isMarked()) {
                                            currentPhrase.setMarked(false);
                                            if (currentPhrase.getText().length() >= 2 || !currentPhrase.getName().endsWith("key") && !currentPhrase.getName().endsWith("Key")) continue;
                                            currentPhrase.setKeepOriginal(true);
                                            continue;
                                        }
                                        phraseIterator.remove();
                                    }
                                    currentFile.setMarked(false);
                                    continue;
                                }
                                fileIterator.remove();
                            }
                            currentSubComponent.setMarked(false);
                            continue;
                        }
                        subComponentIterator.remove();
                    }
                    currentComponent.setMarked(false);
                    continue;
                }
                componentIterator.remove();
            }
            MainWindow.getDefaultInstance().setStatus("Ready");
            ShowWhatDialog swd = new ShowWhatDialog();
            if (!swd.visDialog()) break block12;
            ComplexTableWindow complexTableWindow = new ComplexTableWindow("Changed Strings", this.collectedList, swd.getSelectedColumns(), swd.getSelectedLocale());
        }
    }

    private void updateFromDirectory() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        String baseName = this.install.getPath();
        baseName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(baseName))).append(File.separator).append("locale").append(File.separator).append("en-US")));
        File baseFile = new File(baseName);
        int filesDone = 0;
        String[] components = baseFile.list();
        for (int i = 0; i < components.length; ++i) {
            File currentComponentFile = new File(baseFile, components[i]);
            if (!currentComponentFile.isDirectory()) continue;
            MozComponent currentComponent = (MozComponent)this.install.getChildByName(components[i]);
            if (currentComponent == null) {
                currentComponent = new MozComponent(components[i], this.install);
                this.install.addChild(currentComponent);
            }
            currentComponent.setMarked(true);
            String[] subcomponents = currentComponentFile.list();
            for (int j = 0; j < subcomponents.length; ++j) {
                MozFile currentFile;
                MozComponent currentSubComponent;
                File currentSubComponentFile = new File(currentComponentFile, subcomponents[j]);
                if (currentSubComponentFile.isDirectory()) {
                    currentSubComponent = (MozComponent)currentComponent.getChildByName(subcomponents[j]);
                    if (currentSubComponent == null) {
                        currentSubComponent = new MozComponent(subcomponents[j], currentComponent);
                        currentComponent.addChild(currentSubComponent);
                    }
                    currentSubComponent.setMarked(true);
                    String[] files = currentSubComponentFile.list();
                    for (int k = 0; k < files.length; ++k) {
                        File currentFileFile = new File(currentSubComponentFile, files[k]);
                        currentFile = (MozFile)currentSubComponent.getChildByName(files[k]);
                        if (currentFile == null) {
                            currentFile = new MozFile(files[k], currentSubComponent);
                            currentSubComponent.addChild(currentFile);
                        }
                        currentFile.setMarked(true);
                        vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Files done : ").append(filesDone).append(", currently reading : ").append(currentFile))));
                        this.readFile(currentFileFile, currentFile);
                        ++filesDone;
                    }
                    continue;
                }
                currentSubComponent = (MozComponent)currentComponent.getChildByName("MT_default");
                if (currentSubComponent == null) {
                    currentSubComponent = new MozComponent("MT_default", currentComponent);
                    currentComponent.addChild(currentSubComponent);
                }
                currentSubComponent.setMarked(true);
                currentFile = (MozFile)currentSubComponent.getChildByName(subcomponents[j]);
                if (currentFile == null) {
                    currentFile = new MozFile(subcomponents[j], currentSubComponent);
                    currentSubComponent.addChild(currentFile);
                }
                currentFile.setMarked(true);
                vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Files done : ").append(filesDone).append(", currently reading : ").append(currentFile))));
                this.readFile(currentSubComponentFile, currentFile);
                ++filesDone;
            }
        }
    }

    private void updateFromJar() throws IOException, FileNotFoundException {
        boolean done = false;
        String componentToken = null;
        String lnameToken = null;
        String localeToken = null;
        String subcomponentToken = null;
        String fileToken = null;
        int filesDone = 0;
        MainWindow vindue = MainWindow.getDefaultInstance();
        String baseName = this.install.getPath();
        FileInputStream fis = new FileInputStream(baseName);
        JarInputStream jis = new JarInputStream(fis);
        BufferedInputStream bis = new BufferedInputStream(jis);
        while (!done) {
            JarEntry je = jis.getNextJarEntry();
            if (je != null) {
                StringTokenizer tokens = new StringTokenizer(je.getName(), "/", false);
                localeToken = tokens.nextToken();
                if (tokens.hasMoreTokens()) {
                    lnameToken = tokens.nextToken();
                    if (tokens.hasMoreTokens()) {
                        componentToken = tokens.nextToken();
                    }
                    if (tokens.hasMoreTokens()) {
                        subcomponentToken = tokens.nextToken();
                    }
                    if (tokens.hasMoreTokens()) {
                        fileToken = tokens.nextToken();
                    } else {
                        fileToken = subcomponentToken;
                        subcomponentToken = "MT_default";
                    }
                }
                if (fileToken == null) continue;
                MozComponent currentComponent = (MozComponent)this.install.getChildByName(componentToken);
                if (currentComponent == null) {
                    currentComponent = new MozComponent(componentToken, this.install);
                    this.install.addChild(currentComponent);
                }
                currentComponent.setMarked(true);
                MozComponent currentSubComponent = (MozComponent)currentComponent.getChildByName(subcomponentToken);
                if (currentSubComponent == null) {
                    currentSubComponent = new MozComponent(subcomponentToken, currentComponent);
                    currentComponent.addChild(currentSubComponent);
                }
                currentSubComponent.setMarked(true);
                MozFile currentFile = (MozFile)currentSubComponent.getChildByName(fileToken);
                if (currentFile == null) {
                    currentFile = new MozFile(fileToken, currentSubComponent);
                    currentSubComponent.addChild(currentFile);
                }
                currentFile.setMarked(true);
                vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Files done : ").append(filesDone).append(", currently reading : ").append(currentFile))));
                ++filesDone;
                File tempFile = this.copyToTemp(je, bis);
                this.readFile(tempFile, currentFile);
                componentToken = null;
                localeToken = null;
                subcomponentToken = null;
                fileToken = null;
                lnameToken = null;
                continue;
            }
            done = true;
        }
    }

    private void readFile(File r_fil, MozFile m_fil) {
        block5: {
            try {
                FileInputStream fis = new FileInputStream(r_fil);
                MozFileReader reader = MozIo.getFileReader(m_fil, fis);
                if (reader != null) {
                    reader.readFile("en-US", this.collectedList);
                    break block5;
                }
                Log.write("Reading unsupported fil".concat(String.valueOf(String.valueOf(m_fil))));
                Phrase tempPhrase = new Phrase("MT_UknownFileType", m_fil, "unoen", "Uknown filetype!!!", true);
                m_fil.addChild(tempPhrase);
                long fileSize = r_fil.length();
                StringBuffer rawBuild = new StringBuffer((int)fileSize);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                boolean theEnd = false;
                while (!theEnd) {
                    int number = br.read();
                    if (number == -1) {
                        theEnd = true;
                        continue;
                    }
                    char letter = (char)number;
                    rawBuild.append(letter);
                }
                tempPhrase.setText(rawBuild.toString());
                tempPhrase.setMarked(true);
            }
            catch (Exception e) {
                Log.write(String.valueOf(String.valueOf(new StringBuffer("Error during file read, Real File=").append(r_fil).append(", MT file=").append(m_fil))));
                Log.write("Exception : ".concat(String.valueOf(String.valueOf(e))));
            }
        }
    }

    private File copyToTemp(JarEntry e, BufferedInputStream bis) throws IOException {
        File temp = File.createTempFile("MT_", null);
        temp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(temp);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            bos.write(trans);
        }
        bos.close();
        return temp;
    }
}

