/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.io.MozFileWriter;
import org.mozilla.translator.io.MozProperties;
import org.mozilla.translator.kernel.Settings;

public class PropertiesWriter
extends MozFileWriter {
    private static String header = String.valueOf(String.valueOf(new StringBuffer("Translated with MozillaTranslator ").append(Settings.getString("System.Version", "(unknown version)")).append("  ")));

    public PropertiesWriter(MozFile f, OutputStream o) {
        super(f, o);
    }

    public void writeFile(String localeName) throws IOException {
        Properties prop = Settings.getBoolean("mozbug.nobackslash", false) ? new MozProperties() : new Properties();
        Iterator phraseIterator = this.fil.getChildIterator();
        while (phraseIterator.hasNext()) {
            Phrase currentPhrase = (Phrase)phraseIterator.next();
            String key = currentPhrase.getName();
            Translation currentTranslation = (Translation)currentPhrase.getChildByName(localeName);
            String text = currentTranslation == null || localeName.equals("en-us") || currentPhrase.getKeepOriginal() ? currentPhrase.getText() : currentTranslation.getText();
            prop.setProperty(key, text);
        }
        prop.store(this.os, header);
        this.os.close();
    }
}

