/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.io.CopyWriter;
import org.mozilla.translator.io.DTDReader;
import org.mozilla.translator.io.DTDWriter;
import org.mozilla.translator.io.MozFileReader;
import org.mozilla.translator.io.MozFileWriter;
import org.mozilla.translator.io.PropertiesReader;
import org.mozilla.translator.io.PropertiesWriter;

public class MozIo {
    public static MozFileReader getFileReader(MozFile mfil, InputStream is) {
        MozFileReader result = null;
        int type = mfil.getType();
        switch (type) {
            case 1: {
                result = new DTDReader(mfil, is);
                break;
            }
            case 2: {
                result = new PropertiesReader(mfil, is);
                break;
            }
            case 4: {
                result = null;
            }
        }
        return result;
    }

    public static MozFileWriter getFileWriter(MozFile mfil, OutputStream os) {
        MozFileWriter result = null;
        int type = mfil.getType();
        switch (type) {
            case 1: {
                result = new DTDWriter(mfil, os);
                break;
            }
            case 2: {
                result = new PropertiesWriter(mfil, os);
                break;
            }
            case 4: {
                result = new CopyWriter(mfil, os);
            }
        }
        return result;
    }
}

