/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.io.MozFileReader;
import org.mozilla.translator.io.MozInstallAccess;
import org.mozilla.translator.io.MozIo;
import org.mozilla.translator.kernel.Log;

public class LocaleAccess
implements MozInstallAccess {
    private MozInstall install;
    private String location;
    private String localeName;
    private MainWindow vindue;

    public LocaleAccess(MozInstall i, String loc, String ln) {
        this.install = i;
        this.location = loc;
        this.localeName = ln;
        this.vindue = MainWindow.getDefaultInstance();
    }

    public void load() {
        File locFile = new File(this.location);
        if (locFile.isDirectory()) {
            this.readFromDirectory();
        } else {
            if (this.location.endsWith("jar")) {
                // empty if block
            }
            this.readFromJar();
            if (this.location.endsWith("xpi")) {
                // empty if block
            }
            this.readFromXPI();
        }
        this.vindue.setStatus("Ready");
    }

    private void readFromDirectory() {
        int filesDone = 0;
        String baseName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.location))).append(File.separator).append("locale").append(File.separator).append(this.localeName)));
        File baseFile = new File(baseName);
        String[] components = baseFile.list();
        for (int componentCount = 0; componentCount < components.length; ++componentCount) {
            MozComponent currentComponent = (MozComponent)this.install.getChildByName(components[componentCount]);
            if (currentComponent == null) continue;
            File currentComponentFile = new File(baseFile, components[componentCount]);
            String[] subcomponents = currentComponentFile.list();
            for (int subcomponentCount = 0; subcomponentCount < subcomponents.length; ++subcomponentCount) {
                MozFile currentFile;
                MozComponent currentSubcomponent;
                File currentSubcomponentFile = new File(currentComponentFile, subcomponents[subcomponentCount]);
                if (currentSubcomponentFile.isDirectory()) {
                    currentSubcomponent = (MozComponent)currentComponent.getChildByName(subcomponents[subcomponentCount]);
                    if (currentSubcomponent == null) continue;
                    String[] files = currentSubcomponentFile.list();
                    for (int filesCount = 0; filesCount < files.length; ++filesCount) {
                        currentFile = (MozFile)currentSubcomponent.getChildByName(files[filesCount]);
                        if (currentFile == null) continue;
                        File currentFileFile = new File(currentSubcomponentFile, files[filesCount]);
                        this.vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("files done: ").append(filesDone).append(",currently reading: ").append(currentFile))));
                        this.readFile(currentFileFile, currentFile);
                        ++filesDone;
                    }
                    continue;
                }
                currentSubcomponent = (MozComponent)currentComponent.getChildByName("MT_default");
                if (currentSubcomponent == null || (currentFile = (MozFile)currentSubcomponent.getChildByName(subcomponents[subcomponentCount])) == null) continue;
                this.vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("files done: ").append(filesDone).append(",currently reading: ").append(currentFile))));
                this.readFile(currentSubcomponentFile, currentFile);
                ++filesDone;
            }
        }
    }

    private void readFromJar() {
        boolean done = false;
        String componentToken = null;
        String localeToken = null;
        String subcomponentToken = null;
        String fileToken = null;
        String lnameToken = null;
        int filesDone = 0;
        try {
            FileInputStream fis = new FileInputStream(this.location);
            JarInputStream jis = new JarInputStream(fis);
            BufferedInputStream bis = new BufferedInputStream(jis);
            while (!done) {
                JarEntry je = jis.getNextJarEntry();
                if (je != null) {
                    MozFile currentFile;
                    MozComponent currentSubComponent;
                    MozComponent currentComponent;
                    Log.write("je.getName ".concat(String.valueOf(String.valueOf(je.getName()))));
                    StringTokenizer tokens = new StringTokenizer(je.getName(), "/", false);
                    localeToken = tokens.nextToken();
                    lnameToken = tokens.nextToken();
                    componentToken = tokens.nextToken();
                    if (tokens.hasMoreTokens()) {
                        if (tokens.hasMoreTokens()) {
                            subcomponentToken = tokens.nextToken();
                        }
                        if (tokens.hasMoreTokens()) {
                            fileToken = tokens.nextToken();
                        } else {
                            fileToken = subcomponentToken;
                            subcomponentToken = "MT_default";
                        }
                    }
                    if (fileToken == null || (currentComponent = (MozComponent)this.install.getChildByName(componentToken)) == null || (currentSubComponent = (MozComponent)currentComponent.getChildByName(subcomponentToken)) == null || (currentFile = (MozFile)currentSubComponent.getChildByName(fileToken)) == null) continue;
                    this.vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Files done : ").append(filesDone).append(", currently reading : ").append(currentFile))));
                    ++filesDone;
                    File tempFile = this.copyToTemp(je, bis);
                    this.readFile(tempFile, currentFile);
                    componentToken = null;
                    localeToken = null;
                    lnameToken = null;
                    subcomponentToken = null;
                    fileToken = null;
                    continue;
                }
                done = true;
            }
        }
        catch (Exception e) {
            Log.write("error reading from jar");
            Log.write("Exception : ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    private void readFromXPI() {
    }

    private void readFile(File r_fil, MozFile m_fil) {
        try {
            FileInputStream fis = new FileInputStream(r_fil);
            MozFileReader reader = MozIo.getFileReader(m_fil, fis);
            if (reader != null) {
                reader.readFile(this.localeName, null);
            }
        }
        catch (Exception e) {
            Log.write("Real File = ".concat(String.valueOf(String.valueOf(r_fil))));
            Log.write("MT file   = ".concat(String.valueOf(String.valueOf(m_fil))));
            Log.write("Error during file read");
        }
    }

    private File copyToTemp(JarEntry e, BufferedInputStream bis) throws IOException {
        File temp = File.createTempFile("MT_", null);
        Log.write("Copy To Temp=".concat(String.valueOf(String.valueOf(temp.getName()))));
        FileOutputStream fos = new FileOutputStream(temp);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            bos.write(trans);
        }
        bos.close();
        return temp;
    }

    public void save() {
    }
}

