/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.models;

import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.kernel.Log;

public class ComplexColumn {
    public static final int FIELD_INSTALL = 1;
    public static final int FIELD_COMPONENT = 2;
    public static final int FIELD_SUBCOMPONENT = 3;
    public static final int FIELD_FILE = 4;
    public static final int FIELD_KEY = 5;
    public static final int FIELD_ORIGINAL_TEXT = 6;
    public static final int FIELD_NOTE = 7;
    public static final int FIELD_KEEP = 8;
    public static final int FIELD_TRANSLATED_TEXT = 9;
    public static final int FIELD_QASTATUS = 10;
    public static final int FIELD_QACOMMENT = 11;
    public static final int FIELD_TRANSLATED_ACCESSKEY = 12;
    public static final int FIELD_TRANSLATED_COMMANDKEY = 13;
    public static final int FIELD_ORIGINAL_ACCESSKEY = 14;
    public static final int FIELD_ORIGINAL_COMMANDKEY = 15;
    public static final int FIELD_CURRENT_TEXT = 16;
    public static final int FIELD_CURRENT_ACCESSKEY = 17;
    public static final int FIELD_CURRENT_COMMANDKEY = 18;
    private static Class bclass;
    private static Class iclass;
    private static Class sclass;
    private int field;

    public static void init() {
        try {
            bclass = Class.forName("java.lang.Boolean");
            iclass = Class.forName("java.lang.Integer");
            sclass = Class.forName("java.lang.String");
        }
        catch (Exception e) {
            Log.write("Error initializing complexcolumn data");
        }
    }

    public ComplexColumn(int f) {
        this.field = f;
    }

    public int getField() {
        return this.field;
    }

    public String getName() {
        String result = "";
        switch (this.field) {
            case 1: {
                result = "Install";
                break;
            }
            case 2: {
                result = "Component";
                break;
            }
            case 3: {
                result = "Subcomponent";
                break;
            }
            case 4: {
                result = "File";
                break;
            }
            case 5: {
                result = "Key";
                break;
            }
            case 6: {
                result = "Org. Text";
                break;
            }
            case 7: {
                result = "Localization note";
                break;
            }
            case 8: {
                result = "Keep";
                break;
            }
            case 9: {
                result = "Translated Text";
                break;
            }
            case 10: {
                result = "QA status";
                break;
            }
            case 11: {
                result = "QA comment";
                break;
            }
            case 14: {
                result = "Org. accessKey";
                break;
            }
            case 15: {
                result = "Org. commandKey";
                break;
            }
            case 12: {
                result = "Translated accesskey";
                break;
            }
            case 13: {
                result = "Translated commandkey";
                break;
            }
            case 16: {
                result = "Current text";
                break;
            }
            case 17: {
                result = "Current accesskey";
                break;
            }
            case 18: {
                result = "Current commandkey";
            }
        }
        return result;
    }

    public Class getColumnClass() {
        Class result = null;
        switch (this.field) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                result = sclass;
                break;
            }
            case 8: {
                result = bclass;
                break;
            }
            case 10: {
                result = iclass;
            }
        }
        return result;
    }

    public boolean isEditable(Phrase p, String localeName) {
        boolean result = false;
        switch (this.field) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                result = false;
                break;
            }
            case 7: 
            case 8: {
                result = true;
                break;
            }
            case 9: 
            case 16: {
                if (p.getKeepOriginal()) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 10: 
            case 11: {
                if (p.getChildByName(localeName) != null) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            case 12: 
            case 17: {
                if (p.getAccessConnection() != null) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            case 13: 
            case 18: {
                result = p.getCommandConnection() != null;
            }
        }
        return result;
    }

    public Object getValue(Phrase p, String localeName) {
        Object result = null;
        switch (this.field) {
            case 1: {
                result = p.getParent().getParent().getParent().getParent().toString();
                break;
            }
            case 2: {
                result = p.getParent().getParent().getParent().toString();
                break;
            }
            case 3: {
                result = p.getParent().getParent().toString();
                break;
            }
            case 4: {
                result = p.getParent().toString();
                break;
            }
            case 5: {
                result = p.getName();
                break;
            }
            case 6: {
                if (p.getNote().equals("Uknown filetype!!!")) {
                    result = String.valueOf(String.valueOf(new StringBuffer("[").append("Uknown filetype!!!").append("]")));
                    break;
                }
                result = p.getText();
                break;
            }
            case 7: {
                result = p.getNote();
                break;
            }
            case 8: {
                result = new Boolean(p.getKeepOriginal());
                break;
            }
            case 14: {
                result = "";
                Phrase otherPhrase = p.getAccessConnection();
                if (otherPhrase == null) break;
                result = otherPhrase.getText();
                break;
            }
            case 12: {
                Translation trans;
                result = "";
                Phrase otherPhrase = p.getAccessConnection();
                if (otherPhrase == null || (trans = (Translation)otherPhrase.getChildByName(localeName)) == null) break;
                result = trans.getText();
                break;
            }
            case 17: {
                result = "";
                Phrase otherPhrase = p.getAccessConnection();
                if (otherPhrase == null) break;
                Translation trans = (Translation)otherPhrase.getChildByName(localeName);
                if (trans == null || otherPhrase.getKeepOriginal()) {
                    result = otherPhrase.getText();
                    break;
                }
                result = trans.getText();
                break;
            }
            case 15: {
                result = "";
                Phrase otherPhrase = p.getCommandConnection();
                if (otherPhrase == null) break;
                result = otherPhrase.getText();
                break;
            }
            case 13: {
                Translation trans;
                result = "";
                Phrase otherPhrase = p.getCommandConnection();
                if (otherPhrase == null || (trans = (Translation)otherPhrase.getChildByName(localeName)) == null) break;
                result = trans.getText();
                break;
            }
            case 18: {
                result = "";
                Phrase otherPhrase = p.getCommandConnection();
                if (otherPhrase == null) break;
                Translation trans = (Translation)otherPhrase.getChildByName(localeName);
                if (trans == null || otherPhrase.getKeepOriginal()) {
                    result = otherPhrase.getText();
                    break;
                }
                result = trans.getText();
                break;
            }
            case 9: {
                result = "";
                Translation trans = (Translation)p.getChildByName(localeName);
                if (trans == null) break;
                result = trans.getText();
                break;
            }
            case 16: {
                result = "";
                Translation trans = (Translation)p.getChildByName(localeName);
                if (trans == null || p.getKeepOriginal()) {
                    result = p.getText();
                    break;
                }
                result = trans.getText();
                break;
            }
            case 10: {
                Translation trans = (Translation)p.getChildByName(localeName);
                if (trans != null) {
                    result = new Integer(trans.getStatus());
                    break;
                }
                result = new Integer(0);
                break;
            }
            case 11: {
                result = "";
                Translation trans = (Translation)p.getChildByName(localeName);
                if (trans == null) break;
                result = trans.getComment();
                break;
            }
        }
        return result;
    }

    public void setValue(Phrase p, Object value, String localeName) {
        switch (this.field) {
            case 7: {
                p.setNote(value.toString());
                break;
            }
            case 8: {
                Boolean boolValue = (Boolean)value;
                p.setKeepOriginal(boolValue);
                break;
            }
            case 9: 
            case 16: {
                String strValue = (String)value;
                if (!strValue.equals("")) {
                    Translation pair = (Translation)p.getChildByName(localeName);
                    if (pair == null) {
                        pair = new Translation(localeName, p, strValue);
                        p.addChild(pair);
                        break;
                    }
                    pair.setText(strValue);
                    break;
                }
                p.removeChild(p.getChildByName(localeName));
                break;
            }
            case 10: {
                Integer intValue = (Integer)value;
                Translation pair = (Translation)p.getChildByName(localeName);
                if (pair == null) break;
                pair.setStatus(intValue);
                break;
            }
            case 11: {
                String strValue = (String)value;
                Translation pair = (Translation)p.getChildByName(localeName);
                if (pair == null) break;
                pair.setComment(strValue);
                break;
            }
            case 12: 
            case 17: {
                String strValue = (String)value;
                Phrase otherPhrase = p.getAccessConnection();
                if (otherPhrase == null) break;
                if (!strValue.equals("")) {
                    Translation pair = (Translation)otherPhrase.getChildByName(localeName);
                    if (pair == null) {
                        pair = new Translation(localeName, otherPhrase, strValue);
                        otherPhrase.addChild(pair);
                        break;
                    }
                    pair.setText(strValue);
                    break;
                }
                otherPhrase.removeChild(otherPhrase.getChildByName(localeName));
                break;
            }
            case 13: 
            case 18: {
                String strValue = (String)value;
                Phrase otherPhrase = p.getCommandConnection();
                if (otherPhrase == null) break;
                if (!strValue.equals("")) {
                    Translation pair = (Translation)otherPhrase.getChildByName(localeName);
                    if (pair == null) {
                        pair = new Translation(localeName, otherPhrase, strValue);
                        otherPhrase.addChild(pair);
                        break;
                    }
                    pair.setText(strValue);
                    break;
                }
                otherPhrase.removeChild(otherPhrase.getChildByName(localeName));
                break;
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    static {
        FIELD_INSTALL = 1;
        FIELD_COMPONENT = 2;
        FIELD_SUBCOMPONENT = 3;
        FIELD_FILE = 4;
        FIELD_KEY = 5;
        FIELD_ORIGINAL_TEXT = 6;
        FIELD_NOTE = 7;
        FIELD_KEEP = 8;
        FIELD_TRANSLATED_TEXT = 9;
        FIELD_QASTATUS = 10;
        FIELD_QACOMMENT = 11;
        FIELD_TRANSLATED_ACCESSKEY = 12;
        FIELD_TRANSLATED_COMMANDKEY = 13;
        FIELD_ORIGINAL_ACCESSKEY = 14;
        FIELD_ORIGINAL_COMMANDKEY = 15;
        FIELD_CURRENT_TEXT = 16;
        FIELD_CURRENT_ACCESSKEY = 17;
        FIELD_CURRENT_COMMANDKEY = 18;
    }
}

