/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.kernel.Utils;

public class SearchDialog
extends JDialog {
    private String searchText;
    private String localeName;
    private String selectedColumn;
    private String selectedRule;
    private boolean selectedCase;
    private boolean okay;
    private JLabel searchLabel;
    private JTextField searchField;
    private JLabel WhereLabel;
    private JComboBox columnCombo;
    private JComboBox ruleCombo;
    private JLabel localeLabel;
    private JTextField localeField;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel howLabel;
    private JCheckBox caseCheck;

    public SearchDialog(Frame parent, boolean modal) {
        super(parent, "Search", modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Utils.placeFrameAtCenter(this);
    }

    private void initComponents() {
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.WhereLabel = new JLabel();
        this.columnCombo = new JComboBox();
        this.ruleCombo = new JComboBox();
        this.localeLabel = new JLabel();
        this.localeField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.howLabel = new JLabel();
        this.caseCheck = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.searchLabel.setText("Search for ");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.searchLabel, gridBagConstraints1);
        this.searchField.setText("x");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.getContentPane().add((Component)this.searchField, gridBagConstraints1);
        this.WhereLabel.setText("Where");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.WhereLabel, gridBagConstraints1);
        this.columnCombo.addItem("Key");
        this.columnCombo.addItem("Localization note");
        this.columnCombo.addItem("Original text");
        this.columnCombo.addItem("Translated text");
        this.columnCombo.addItem("QA comment");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.getContentPane().add((Component)this.columnCombo, gridBagConstraints1);
        this.ruleCombo.addItem("Is");
        this.ruleCombo.addItem("Is not");
        this.ruleCombo.addItem("Contains");
        this.ruleCombo.addItem("Doesn't contain");
        this.ruleCombo.addItem("Starts with");
        this.ruleCombo.addItem("Ends with");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.getContentPane().add((Component)this.ruleCombo, gridBagConstraints1);
        this.localeLabel.setText("Locale");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.localeLabel, gridBagConstraints1);
        this.localeField.setText("da-DK");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.getContentPane().add((Component)this.localeField, gridBagConstraints1);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.okPressed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.okButton, gridBagConstraints1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.cancelPressed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(3, 2, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints1);
        this.howLabel.setText("how");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.howLabel, gridBagConstraints1);
        this.caseCheck.setSelected(true);
        this.caseCheck.setText("Casesensitive");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.getContentPane().add((Component)this.caseCheck, gridBagConstraints1);
    }

    private void okPressed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    private void cancelPressed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    public boolean visDialog() {
        this.okay = false;
        this.localeField.setText(Settings.getString("saved.localeName", ""));
        this.searchField.setText(Settings.getString("saved.search.text", ""));
        this.columnCombo.setSelectedIndex(Settings.getInteger("saved.search.field", 0));
        this.ruleCombo.setSelectedIndex(Settings.getInteger("saved.search.rule", 0));
        this.caseCheck.setSelected(Settings.getBoolean("saved.search.case", false));
        ((Component)this).setVisible(true);
        if (this.okay) {
            Settings.setString("saved.localeName", this.localeField.getText());
            Settings.setString("saved.search.text", this.searchField.getText());
            Settings.setInteger("saved.search.field", this.columnCombo.getSelectedIndex());
            Settings.setInteger("saved.search.rule", this.ruleCombo.getSelectedIndex());
            Settings.setBoolean("saved.search.case", this.caseCheck.isSelected());
        }
        this.searchText = this.searchField.getText();
        this.localeName = this.localeField.getText();
        this.selectedColumn = this.columnCombo.getSelectedItem().toString();
        this.selectedRule = this.ruleCombo.getSelectedItem().toString();
        this.selectedCase = this.caseCheck.isSelected();
        this.dispose();
        return this.okay;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public String getColumn() {
        return this.selectedColumn;
    }

    public String getRule() {
        return this.selectedRule;
    }

    public boolean getCase() {
        return this.selectedCase;
    }
}

