/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.kernel.Utils;

public class EditInstallDialog
extends JDialog {
    private JPanel infoPanel;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel pathLabel;
    private JTextField pathField;
    private JButton pathButton;
    private JLabel opathLabel;
    private JTextField opathField;
    private JButton opathButton;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okay;
    private MozInstall install;

    public EditInstallDialog(Frame parent, MozInstall mzi) {
        super(parent, "Edit Installation", true);
        this.install = mzi;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Utils.placeFrameAtCenter(this);
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.pathLabel = new JLabel();
        this.pathField = new JTextField();
        this.pathButton = new JButton();
        this.opathLabel = new JLabel();
        this.opathField = new JTextField();
        this.opathButton = new JButton();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditInstallDialog.this.closeWindow(evt);
            }
        });
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(new TitledBorder(new EtchedBorder(), "Install Information", 4, 2, new Font("Dialog", 0, 10)));
        this.nameLabel.setText("Name");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.infoPanel.add((Component)this.nameLabel, gridBagConstraints2);
        this.nameField.setColumns(30);
        this.nameField.setText("Mozilla M16");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infoPanel.add((Component)this.nameField, gridBagConstraints2);
        this.pathLabel.setText("Orig Jar Path");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 0);
        gridBagConstraints2.anchor = 17;
        this.infoPanel.add((Component)this.pathLabel, gridBagConstraints2);
        this.pathField.setColumns(30);
        this.pathField.setText("C:\\program files\\mozilla\\chrome");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 0);
        gridBagConstraints2.anchor = 17;
        this.infoPanel.add((Component)this.pathField, gridBagConstraints2);
        this.pathButton.setToolTipText("Choose directory or jar file for the install");
        this.pathButton.setText("Choose");
        this.pathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditInstallDialog.this.pathButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        this.infoPanel.add((Component)this.pathButton, gridBagConstraints2);
        this.opathLabel.setText("Output Jar Path");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 0);
        gridBagConstraints2.anchor = 17;
        this.infoPanel.add((Component)this.opathLabel, gridBagConstraints2);
        this.opathField.setColumns(30);
        this.opathField.setText("C:\\program files\\mozilla\\chrome");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 0);
        gridBagConstraints2.anchor = 17;
        this.infoPanel.add((Component)this.opathField, gridBagConstraints2);
        this.opathButton.setToolTipText("Choose directory or jar file for the install");
        this.opathButton.setText("Choose");
        this.opathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditInstallDialog.this.opathButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        this.infoPanel.add((Component)this.opathButton, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.infoPanel, gridBagConstraints1);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton.setToolTipText("Leaves and saves the information");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditInstallDialog.this.okButtonPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 3, 3, 2);
        gridBagConstraints3.anchor = 12;
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setToolTipText("Leaveswithout saving the information");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditInstallDialog.this.cancelButtonPressed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = new Insets(0, 2, 3, 3);
        gridBagConstraints3.anchor = 18;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints1);
    }

    private void pathButtonPressed(ActionEvent evt) {
        File defaultFile = new File(this.pathField.getText());
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setFileSelectionMode(2);
        dirChooser.setDialogTitle("Select directory or jar file for the install");
        dirChooser.setSelectedFile(defaultFile);
        int result = dirChooser.showDialog(this, "Choose");
        if (result == 0) {
            File dir = dirChooser.getSelectedFile();
            this.pathField.setText(dir.toString());
        }
    }

    private void opathButtonPressed(ActionEvent evt) {
        File defaultFile = new File(this.opathField.getText());
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setFileSelectionMode(2);
        dirChooser.setDialogTitle("Select directory or jar file for the install");
        dirChooser.setSelectedFile(defaultFile);
        int result = dirChooser.showDialog(this, "Choose");
        if (result == 0) {
            File dir = dirChooser.getSelectedFile();
            this.opathField.setText(dir.toString());
        }
    }

    private void closeWindow(WindowEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    private void cancelButtonPressed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    private void okButtonPressed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    public boolean visDialog() {
        this.nameField.setText(this.install.getName());
        this.pathField.setText(this.install.getPath());
        this.opathField.setText(this.install.getOutputPath());
        ((Component)this).setVisible(true);
        if (this.okay) {
            this.install.setOutputPath(this.opathField.getText());
            this.install.setPath(this.pathField.getText());
            this.install.setName(this.nameField.getText());
        }
        this.dispose();
        return this.okay;
    }
}

