/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.mozilla.translator.datamodel.Filter;
import org.mozilla.translator.fetch.FetchRunner;
import org.mozilla.translator.fetch.FetchSearch;
import org.mozilla.translator.gui.ComplexTableWindow;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.dialog.SearchDialog;
import org.mozilla.translator.gui.dialog.ShowWhatDialog;

public class SearchViewAction
extends AbstractAction {
    private int rule;
    private int column;
    private String rul;
    private String col;
    private boolean cc;

    public SearchViewAction() {
        super("Simple Search", null);
    }

    public void actionPerformed(ActionEvent evt) {
        block1: {
            MainWindow mw = MainWindow.getDefaultInstance();
            SearchDialog sd = new SearchDialog((Frame)mw, true);
            boolean okay = sd.visDialog();
            if (!okay) break block1;
            this.rule = 0;
            this.column = 0;
            this.rul = sd.getRule();
            this.col = sd.getColumn();
            String lname = sd.getLocaleName();
            String text = sd.getSearchText();
            this.cc = sd.getCase();
            this.assignRule(1, "Is");
            this.assignRule(2, "Is not");
            this.assignRule(3, "Contains");
            this.assignRule(4, "Doesn't contain");
            this.assignRule(5, "Starts with");
            this.assignRule(6, "Ends with");
            this.assignColumn(1, "Key");
            this.assignColumn(3, "Localization note");
            this.assignColumn(2, "Original text");
            this.assignColumn(5, "Translated text");
            this.assignColumn(4, "QA comment");
            Filter search = new Filter(this.rule, this.column, text, this.cc, lname);
            ShowWhatDialog swd = new ShowWhatDialog();
            swd.disableLocaleField();
            if (swd.visDialog()) {
                String localeName = swd.getSelectedLocale();
                List cols = swd.getSelectedColumns();
                FetchSearch sf = new FetchSearch(search);
                List collectedList = FetchRunner.getFromGlossary(sf);
                Collections.sort(collectedList);
                ComplexTableWindow complexTableWindow = new ComplexTableWindow("Found Strings", collectedList, cols, localeName);
            }
        }
    }

    private void assignRule(int value, String comp) {
        if (this.rul.equals(comp)) {
            this.rule = value;
        }
    }

    private void assignColumn(int value, String comp) {
        if (this.col.equals(comp)) {
            this.column = value;
        }
    }
}

