/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.actions;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Log;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.runners.SaveGlossaryRunner;

public class QuitAction
extends AbstractAction
implements WindowListener {
    public QuitAction() {
        super("Quit", null);
    }

    public void actionPerformed(ActionEvent evt) {
        this.doExit();
    }

    public void doExit() {
        int result = JOptionPane.showConfirmDialog(MainWindow.getDefaultInstance(), "Save glossary before quiting ?", "Exit MozillaTranslator", 1, 2);
        if (result == 1) {
            Settings.save();
            System.exit(0);
        }
        if (result == 0) {
            Settings.save();
            SaveGlossaryRunner sgr = new SaveGlossaryRunner();
            sgr.start();
            try {
                sgr.join();
                System.exit(0);
            }
            catch (Exception e) {
                Log.write("Error with saving during exit");
                Log.write("Exception : ".concat(String.valueOf(String.valueOf(e))));
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.doExit();
    }
}

