/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Log;

public class ImportOldGlossaryRunner
extends Thread {
    private MozInstall install;
    private String glosFile;

    public ImportOldGlossaryRunner(MozInstall i, String glos) {
        this.install = i;
        this.glosFile = glos;
    }

    public void run() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        Properties prop = new Properties();
        MozComponent allFiles = new MozComponent("temp", null);
        vindue.setStatus("Building list of all files");
        try {
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                Iterator subcomponentIterator = currentComponent.getChildIterator();
                while (subcomponentIterator.hasNext()) {
                    MozComponent currentSubcomponent = (MozComponent)subcomponentIterator.next();
                    Iterator fileIterator = currentSubcomponent.getChildIterator();
                    while (fileIterator.hasNext()) {
                        allFiles.addChild((MozFile)fileIterator.next());
                    }
                }
            }
            vindue.setStatus("Loading old glossary");
            FileInputStream fis = new FileInputStream(this.glosFile);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            prop.load(zis);
            zis.closeEntry();
            zis.close();
            int componentCount = Integer.parseInt(prop.getProperty("componentCount"));
            for (int c = 0; c < componentCount; ++c) {
                String compPrefix = String.valueOf(String.valueOf(new StringBuffer("").append(c).append(".")));
                int fileCount = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(compPrefix)).concat("fileCount")));
                for (int f = 0; f < fileCount; ++f) {
                    String filePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compPrefix))).append(f).append(".")));
                    String fileName = prop.getProperty(String.valueOf(String.valueOf(filePrefix)).concat("name"));
                    MozFile currentFile = (MozFile)allFiles.getChildByName(fileName);
                    if (currentFile == null) continue;
                    vindue.setStatus("Migrateing file : ".concat(String.valueOf(String.valueOf(currentFile.getName()))));
                    int phraseCount = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(filePrefix)).concat("phraseCount")));
                    for (int p = 0; p < phraseCount; ++p) {
                        String locales;
                        String phrasePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(filePrefix))).append(p).append(".")));
                        String key = prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("key"));
                        Phrase currentPhrase = (Phrase)currentFile.getChildByName(key);
                        if (currentPhrase == null || (locales = prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("locales"), "NONE")).equals("NONE")) continue;
                        StringTokenizer localeTokenizer = new StringTokenizer(locales, ",", false);
                        while (localeTokenizer.hasMoreTokens()) {
                            String singleLocale = localeTokenizer.nextToken();
                            String localePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(phrasePrefix))).append(singleLocale).append(".")));
                            String translated = prop.getProperty(String.valueOf(String.valueOf(localePrefix)).concat("text"));
                            int qa = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(localePrefix)).concat("qa"), "0"));
                            String comment = prop.getProperty(String.valueOf(String.valueOf(localePrefix)).concat("comment"), "");
                            Translation currentTranslation = (Translation)currentPhrase.getChildByName(singleLocale);
                            if (currentTranslation != null || translated.equals("")) continue;
                            currentTranslation = new Translation(singleLocale, currentPhrase, translated, qa, comment);
                            currentPhrase.addChild(currentTranslation);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Log.write("Error importing old glossary");
            Log.write("Exception ".concat(String.valueOf(String.valueOf(e))));
        }
        MainWindow.getDefaultInstance().setStatus("Ready");
    }
}

