/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.io.MozFileReader;
import org.mozilla.translator.kernel.Log;

public class DTDReader
extends MozFileReader {
    private static final int STATUS_COMMENT_WAITING = 1;
    private static final int STATUS_COMMENT_BEGUN = 2;
    private static final int STATUS_COMMENT_JUMP = 3;
    private static final int STATUS_COMMENT_SCOPE = 4;
    private static final int STATUS_COMMENT_NOTE = 5;
    private static final int STATUS_ENTITY_KEY = 6;
    private static final int STATUS_ENTITY_TEXT = 7;
    private static final int SCOPE_FILE = 1;
    private static final int SCOPE_BLOCK = 2;
    private static final int SCOPE_KEY = 3;
    private static final String TOKEN_ENTITY = "!ENTITY";
    private static final String TOKEN_COMMENT = "!--";
    private static final String TOKEN_LOCNOTE = "LOCALIZATION";
    private static final String TOKEN_BEGINBLOCK = "BEGIN";
    private static final String TOKEN_ENDBLOCK = "END";
    private InputStreamReader isr;
    private BufferedReader br;
    private boolean globalDone;
    private String key;
    private String text;

    public DTDReader(MozFile f, InputStream i) {
        super(f, i);
    }

    public void readFile(String localeName, List changeList) throws IOException {
        this.isr = new InputStreamReader(this.is, "UTF-8");
        this.br = new BufferedReader(this.isr);
        this.globalDone = false;
        while (!this.globalDone) {
            this.readNextEntry(localeName);
            if (this.key.equals("")) continue;
            Phrase currentPhrase = (Phrase)this.fil.getChildByName(this.key);
            if (localeName.equalsIgnoreCase("en-us")) {
                if (currentPhrase == null) {
                    currentPhrase = new Phrase(this.key, this.fil, this.text, "", false);
                    this.fil.addChild(currentPhrase);
                    changeList.add(currentPhrase);
                } else if (!currentPhrase.getText().equals(this.text)) {
                    currentPhrase.setText(this.text);
                    changeList.add(currentPhrase);
                }
                currentPhrase.setMarked(true);
                continue;
            }
            if (currentPhrase == null) continue;
            Translation currentTranslation = (Translation)currentPhrase.getChildByName(localeName);
            if (currentTranslation == null) {
                currentTranslation = new Translation(localeName, currentPhrase, this.text);
                currentPhrase.addChild(currentTranslation);
                continue;
            }
            currentTranslation.setText(this.text);
        }
    }

    public void readNextEntry(String localeName) {
        boolean entryDone = false;
        StringBuffer segmentBuffer = null;
        boolean entityBegun = false;
        while (!entryDone) {
            int number = this.readNextChar();
            if (number != -1) {
                char letter = (char)number;
                if (entityBegun) {
                    segmentBuffer.append(letter);
                    if (segmentBuffer.toString().equalsIgnoreCase(TOKEN_COMMENT)) {
                        this.readComment();
                        entityBegun = false;
                        continue;
                    }
                    if (segmentBuffer.toString().equalsIgnoreCase(TOKEN_ENTITY)) {
                        this.readEntity();
                        entryDone = true;
                        continue;
                    }
                    if (letter != '>') continue;
                    entityBegun = false;
                    continue;
                }
                if (letter != '<') continue;
                entityBegun = true;
                segmentBuffer = new StringBuffer();
                continue;
            }
            entryDone = true;
            this.globalDone = true;
        }
    }

    public void readEntity() {
        StringBuffer entityBuffer = null;
        int status = 6;
        boolean keyBegun = false;
        boolean textBegun = false;
        boolean more = true;
        char endChar = 'z';
        while (more) {
            int number = this.readNextChar();
            if (number != -1) {
                char letter = (char)number;
                switch (status) {
                    case 6: {
                        if (keyBegun) {
                            if (letter == ' ' || letter == '\t') {
                                this.key = entityBuffer.toString();
                                status = 7;
                                textBegun = false;
                                break;
                            }
                            entityBuffer.append(letter);
                            break;
                        }
                        if (letter == ' ' || letter == '\t') break;
                        keyBegun = true;
                        entityBuffer = new StringBuffer();
                        entityBuffer.append(letter);
                        break;
                    }
                    case 7: {
                        if (textBegun) {
                            if (letter == endChar) {
                                this.text = entityBuffer.toString();
                                this.readSkip();
                                more = false;
                                break;
                            }
                            entityBuffer.append(letter);
                            break;
                        }
                        if (letter != '\"' && letter != '\'') break;
                        textBegun = true;
                        entityBuffer = new StringBuffer();
                        endChar = letter;
                    }
                }
                continue;
            }
            this.globalDone = true;
            more = false;
        }
    }

    private void readComment() {
        this.readSkip();
    }

    private void readSkip() {
        boolean more = true;
        while (more) {
            int number = this.readNextChar();
            if (number != -1) {
                char letter = (char)number;
                if (letter != '>') continue;
                more = false;
                continue;
            }
            more = false;
            this.globalDone = true;
        }
    }

    private int readNextChar() {
        int number;
        try {
            number = this.br.read();
        }
        catch (Exception e) {
            Log.write("Error during reading dtd file");
            Log.write("Exception: ".concat(String.valueOf(String.valueOf(e))));
            number = -1;
        }
        return number;
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (Exception e) {
            Log.write("Error  closing read DTD file");
            Log.write("Exception ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    static {
        STATUS_COMMENT_WAITING = 1;
        STATUS_COMMENT_BEGUN = 2;
        STATUS_COMMENT_JUMP = 3;
        STATUS_COMMENT_SCOPE = 4;
        STATUS_COMMENT_NOTE = 5;
        STATUS_ENTITY_KEY = 6;
        STATUS_ENTITY_TEXT = 7;
        SCOPE_FILE = 1;
        SCOPE_BLOCK = 2;
        SCOPE_KEY = 3;
        TOKEN_ENTITY = TOKEN_ENTITY;
        TOKEN_COMMENT = TOKEN_COMMENT;
        TOKEN_LOCNOTE = TOKEN_LOCNOTE;
        TOKEN_BEGINBLOCK = TOKEN_BEGINBLOCK;
        TOKEN_ENDBLOCK = TOKEN_ENDBLOCK;
    }
}

