/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.kernel.Utils;

public class ExportPartialGlossaryDialog
extends JDialog {
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel infoPanel;
    private JLabel installLabel;
    private JComboBox installCombo;
    private JLabel subcomponentLabel;
    private JLabel fileLabel;
    private JTextField fileField;
    private JButton fileButton;
    private JScrollPane listScroll;
    private JList subcomponentList;
    private boolean okay;

    public ExportPartialGlossaryDialog() {
        super(MainWindow.getDefaultInstance(), "Export partial glossary", true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Utils.placeFrameAtCenter(this);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.infoPanel = new JPanel();
        this.installLabel = new JLabel();
        this.installCombo = this.installCombo = new JComboBox<Object>(Glossary.getDefaultInstance().toArray());
        this.subcomponentLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.fileField = new JTextField();
        this.fileButton = new JButton();
        this.listScroll = new JScrollPane();
        this.subcomponentList = this.subcomponentList = new JList<Object>(this.getSubs());
        this.setDefaultCloseOperation(0);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportPartialGlossaryDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportPartialGlossaryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(new TitledBorder(new EtchedBorder(), "Information", 4, 2, new Font("Dialog", 0, 10)));
        this.installLabel.setText("Install");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.infoPanel.add((Component)this.installLabel, gridBagConstraints1);
        this.installCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportPartialGlossaryDialog.this.installComboActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.infoPanel.add((Component)this.installCombo, gridBagConstraints1);
        this.subcomponentLabel.setText("Subcomponents");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.infoPanel.add((Component)this.subcomponentLabel, gridBagConstraints1);
        this.fileLabel.setText("File");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.infoPanel.add((Component)this.fileLabel, gridBagConstraints1);
        this.fileField.setColumns(20);
        this.fileField.setText("I hate IE");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.infoPanel.add((Component)this.fileField, gridBagConstraints1);
        this.fileButton.setText("Choose");
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportPartialGlossaryDialog.this.fileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.infoPanel.add((Component)this.fileButton, gridBagConstraints1);
        this.subcomponentList.setPrototypeCellValue("some very long subcomponent");
        this.listScroll.setViewportView(this.subcomponentList);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(3, 3, 0, 0);
        this.infoPanel.add((Component)this.listScroll, gridBagConstraints1);
        this.getContentPane().add((Component)this.infoPanel, "Center");
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        File defaultFile = new File(this.fileField.getText());
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setFileSelectionMode(0);
        dirChooser.setDialogTitle("Select file to export to");
        dirChooser.setSelectedFile(defaultFile);
        int result = dirChooser.showDialog(this, "Choose");
        if (result == 0) {
            File dir = dirChooser.getSelectedFile();
            this.fileField.setText(dir.toString());
        }
    }

    private void installComboActionPerformed(ActionEvent evt) {
        this.subcomponentList.setListData(this.getSubs());
    }

    public Object[] getSubs() {
        ArrayList result = new ArrayList();
        MozInstall install = (MozInstall)this.installCombo.getSelectedItem();
        Iterator componentIterator = install.getChildIterator();
        while (componentIterator.hasNext()) {
            MozComponent currentComponent = (MozComponent)componentIterator.next();
            result.addAll(currentComponent.getAllChildren());
        }
        return result.toArray();
    }

    public boolean visDialog() {
        this.fileField.setText(Settings.getString("saved.fileName.partial.export", ""));
        MozInstall preSelect = (MozInstall)Glossary.getDefaultInstance().getChildByName(Settings.getString("saved.install", ""));
        if (preSelect != null) {
            this.installCombo.setSelectedItem(preSelect);
            this.subcomponentList.setListData(this.getSubs());
        }
        ((Component)this).setVisible(true);
        if (this.okay) {
            Settings.setString("saved.fileName.partial.export", this.fileField.getText());
            Settings.setString("saved.install", this.installCombo.getSelectedItem().toString());
        }
        return this.okay;
    }

    public String getFileName() {
        return this.fileField.getText();
    }

    public MozInstall getInstall() {
        return (MozInstall)this.installCombo.getSelectedItem();
    }

    public Object[] getSubcomponents() {
        Object[] result = this.subcomponentList.getSelectedValues();
        for (int i = 0; i < result.length; ++i) {
            Object obj = result[i];
        }
        return result;
    }
}

