/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Utils;

public class EditUnknownDialog
extends JDialog {
    private boolean okay;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JTabbedPane tabs;
    private JPanel originalPanel;
    private JScrollPane originalScroll;
    private JTextArea originalArea;
    private JPanel translatedPanel;
    private JScrollPane translatedScroll;
    private JTextArea translatedArea;

    public EditUnknownDialog() {
        super(MainWindow.getDefaultInstance(), "Edit Unknown file", true);
        this.initComponents();
        this.pack();
        Utils.placeFrameAtCenter(this);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tabs = new JTabbedPane();
        this.originalPanel = new JPanel();
        this.originalScroll = new JScrollPane();
        this.originalArea = new JTextArea();
        this.translatedPanel = new JPanel();
        this.translatedScroll = new JScrollPane();
        this.translatedArea = new JTextArea();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditUnknownDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUnknownDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUnknownDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.originalPanel.setLayout(new BorderLayout());
        this.originalArea.setEditable(false);
        this.originalArea.setColumns(50);
        this.originalArea.setRows(20);
        this.originalScroll.setViewportView(this.originalArea);
        this.originalPanel.add((Component)this.originalScroll, "Center");
        this.tabs.addTab("Original text", this.originalPanel);
        this.translatedPanel.setLayout(new BorderLayout());
        this.translatedArea.setColumns(50);
        this.translatedArea.setRows(20);
        this.translatedScroll.setViewportView(this.translatedArea);
        this.translatedPanel.add((Component)this.translatedScroll, "Center");
        this.tabs.addTab("Translated Text", this.translatedPanel);
        this.getContentPane().add((Component)this.tabs, "Center");
    }

    private void tabSizeButtonActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    public void visDialog(Phrase ph, String localeName) {
        this.originalArea.setText(ph.getText());
        Translation currentTranslation = (Translation)ph.getChildByName(localeName);
        if (currentTranslation == null) {
            this.translatedArea.setText(ph.getText());
        } else {
            this.translatedArea.setText(currentTranslation.getText());
        }
        this.pack();
        Utils.placeFrameAtCenter(this);
        ((Component)this).setVisible(true);
        if (this.okay) {
            if (currentTranslation == null) {
                currentTranslation = new Translation(localeName, ph, this.translatedArea.getText());
                ph.addChild(currentTranslation);
            } else {
                currentTranslation.setText(this.translatedArea.getText());
            }
        }
    }
}

