/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.runners;


import java.io.*;
import java.util.*;
import java.util.zip.*;

import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.io.*;
import org.mozilla.translator.kernel.*;
import org.mozilla.translator.gui.*;
/**
 *
 * @author  Henrik
 * @version
 */
public class ExportTextRunner extends Thread {

    MozInstall install;
    String fileName;
    String localeName;

    /** Creates new ImportPartialGlossary */
    public ExportTextRunner(MozInstall i,String fn,String ln)
    {
        install=i;
        fileName=fn;
        localeName=ln;
    }

    public void run()
    {
        Iterator componentIterator;
        Iterator subcomponentIterator;
        Iterator fileIterator;
        Iterator phraseIterator;
        
        MozComponent currentComponent;
        MozComponent currentSubcomponent;
        MozFile currentFile;
        Phrase currentPhrase;
        Translation currentTranslation;
        FileOutputStream fos;
        PrintWriter pw;
        MainWindow.getDefaultInstance().setStatus("Writeing text file...");
        try
        {
            fos = new FileOutputStream(fileName,false);
            pw  = new PrintWriter(fos); 
            
            componentIterator = install.getChildIterator();
            
            while (componentIterator.hasNext())
            {
                currentComponent = (MozComponent) componentIterator.next();
                
                subcomponentIterator = currentComponent.getChildIterator();
                
                while (subcomponentIterator.hasNext())
                {
                    currentSubcomponent = (MozComponent) subcomponentIterator.next();
                    
                    fileIterator = currentSubcomponent.getChildIterator();
                    
                    while (fileIterator.hasNext())
                    {
                        currentFile = (MozFile) fileIterator.next();
                        
                        phraseIterator = currentFile.getChildIterator();
                        
                        while (phraseIterator.hasNext())
                        {
                            currentPhrase = (Phrase) phraseIterator.next();
                            
                            currentTranslation = (Translation) currentPhrase.getChildByName(localeName);
                            
                            if (currentTranslation!=null)
                            {
                            	  if (currentTranslation.getText().length()>1)
                            	  { 
                                	pw.println(currentTranslation.getText());
                                }
                            }
                        }
                    }
                }
            }
            
            pw.close();
				MainWindow.getDefaultInstance().setStatus("Ready");
        }
        catch (Exception e)
        {
            Log.write("Error in writing text file");
            Log.write("Exception " + e);
        }
    }
}