/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui.dialog;

import java.util.*;
import javax.swing.*;

import org.mozilla.translator.kernel.*;
import org.mozilla.translator.datamodel.*;

import org.mozilla.translator.gui.models.*;
import org.mozilla.translator.gui.*;
/**
 *
 * @author  Henrik
 * @version
 */
public class ShowWhatDialog extends javax.swing.JDialog
{

    /** Creates new form ShowWhatDialog */
    public ShowWhatDialog()
    {
        super (MainWindow.getDefaultInstance(),"Show what ?", true);
        initComponents ();
        getRootPane().setDefaultButton(okButton);
        pack ();
        Utils.placeFrameAtCenter(this);
    }

    public void disableLocaleField()
    {
        localeField.setEnabled(false);
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel ();
        localeLabel = new javax.swing.JLabel ();
        localeField = new javax.swing.JTextField ();
        InstallLabel = new javax.swing.JLabel ();
        installScroll = new javax.swing.JScrollPane ();
        java.util.List colList = new ArrayList();

        colList.add(new ComplexColumn(ComplexColumn.FIELD_INSTALL));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_COMPONENT));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_SUBCOMPONENT));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_FILE));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_KEY));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_ORIGINAL_TEXT));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_ORIGINAL_ACCESSKEY));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_ORIGINAL_COMMANDKEY));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_NOTE));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_KEEP));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_TRANSLATED_TEXT));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_TRANSLATED_ACCESSKEY));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_TRANSLATED_COMMANDKEY));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_QACOMMENT));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_QASTATUS));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_CURRENT_TEXT));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_CURRENT_ACCESSKEY));
        colList.add(new ComplexColumn(ComplexColumn.FIELD_CURRENT_COMMANDKEY));


        installList = new JList(colList.toArray());
        okButton = new javax.swing.JButton ();
        cancelButton = new javax.swing.JButton ();
        getContentPane ().setLayout (new java.awt.GridBagLayout ());
        java.awt.GridBagConstraints gridBagConstraints1;
        setDefaultCloseOperation (javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);

        jPanel1.setLayout (new java.awt.GridBagLayout ());
        java.awt.GridBagConstraints gridBagConstraints2;
        jPanel1.setBorder (new javax.swing.border.TitledBorder(
        new javax.swing.border.EtchedBorder(), "Show what", 4, 2,
        new java.awt.Font ("Dialog", 0, 10)));

          localeLabel.setText ("Locale");
  
          gridBagConstraints2 = new java.awt.GridBagConstraints ();
          gridBagConstraints2.insets = new java.awt.Insets (3, 3, 3, 3);
          gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
          jPanel1.add (localeLabel, gridBagConstraints2);
  
          localeField.setColumns (10);
          localeField.setText ("da-DK");
  
          gridBagConstraints2 = new java.awt.GridBagConstraints ();
          gridBagConstraints2.gridwidth = 0;
          gridBagConstraints2.insets = new java.awt.Insets (3, 0, 3, 3);
          gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
          jPanel1.add (localeField, gridBagConstraints2);
  
          InstallLabel.setText ("columns");
  
          gridBagConstraints2 = new java.awt.GridBagConstraints ();
          gridBagConstraints2.gridx = 0;
          gridBagConstraints2.gridy = 1;
          gridBagConstraints2.insets = new java.awt.Insets (0, 3, 0, 3);
          gridBagConstraints2.anchor = java.awt.GridBagConstraints.NORTHWEST;
          jPanel1.add (InstallLabel, gridBagConstraints2);
  
  
            installList.setPrototypeCellValue (" Localization note ");
            installList.setVisibleRowCount (15);
    
            installScroll.setViewportView (installList);
    
          gridBagConstraints2 = new java.awt.GridBagConstraints ();
          gridBagConstraints2.gridx = 1;
          gridBagConstraints2.gridy = 1;
          gridBagConstraints2.gridwidth = 0;
          gridBagConstraints2.insets = new java.awt.Insets (0, 0, 3, 3);
          gridBagConstraints2.anchor = java.awt.GridBagConstraints.NORTHWEST;
          jPanel1.add (installScroll, gridBagConstraints2);
  

        gridBagConstraints1 = new java.awt.GridBagConstraints ();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets (3, 3, 3, 3);
        getContentPane ().add (jPanel1, gridBagConstraints1);

        okButton.setText ("OK");
        okButton.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                okButtonPressed (evt);
            }
        }
        );


        gridBagConstraints1 = new java.awt.GridBagConstraints ();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets (0, 3, 3, 3);
        getContentPane ().add (okButton, gridBagConstraints1);

        cancelButton.setText ("Cancel");
        cancelButton.addActionListener (new java.awt.event.ActionListener () {
            public void actionPerformed (java.awt.event.ActionEvent evt) {
                cancelButtonPressed (evt);
            }
        }
        );


        gridBagConstraints1 = new java.awt.GridBagConstraints ();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new java.awt.Insets (0, 0, 3, 3);
        getContentPane ().add (cancelButton, gridBagConstraints1);

    }//GEN-END:initComponents

  private void cancelButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonPressed
    okay=false;
    setVisible(false);
  }//GEN-LAST:event_cancelButtonPressed

  private void okButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonPressed
    okay=true;
    setVisible(false);
  }//GEN-LAST:event_okButtonPressed

public boolean visDialog()
{
    int[] selectedFromStart;
    ListSelectionModel lsm;

    Object[] installs = Glossary.getDefaultInstance().toArray();
    MozInstall install = (MozInstall) installs[0];

    localeField.setText(Settings.getString("saved.localeName",""));

    okay=false;
    lsm = installList.getSelectionModel();
    for (int i=0;i<18;i++)
    {
        if (Settings.getBoolean("saved.column." + i,false))
        {
            lsm.addSelectionInterval(i,i);
        }
    }

    setVisible(true);
    if (okay)
    {
        Settings.setString("saved.localeName",localeField.getText());
        for (int i=0;i<18;i++)
        {
            Settings.setBoolean("saved.column." + i,false);
        }
        selectedFromStart = installList.getSelectedIndices();
        for (int i=0;i<selectedFromStart.length;i++)
        {
            Settings.setBoolean("saved.column." + selectedFromStart[i],true);
        }
    }
    return okay;
}
public List getSelectedColumns()
{
    Object[] arrayResult = installList.getSelectedValues();

    List listResult;

    listResult = Arrays.asList(arrayResult);

    return listResult;
}

public String getSelectedLocale()
{
    return localeField.getText();
}

// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel jPanel1;
private javax.swing.JLabel localeLabel;
private javax.swing.JTextField localeField;
private javax.swing.JLabel InstallLabel;
private javax.swing.JScrollPane installScroll;
private javax.swing.JList installList;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
// End of variables declaration//GEN-END:variables
    private boolean okay;
}
