/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui.dialog;

import org.mozilla.translator.kernel.*;
import org.mozilla.translator.gui.*;
/**
 *
 * @author  Henrik
 * @version
 */
public class SetupDialog extends javax.swing.JDialog {

    /** Creates new form SetupDialog */
    public SetupDialog() {
        super (MainWindow.getDefaultInstance(),"Setup MozillaTranslator",true);
        initComponents ();
        pack ();
        Utils.placeFrameAtCenter(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        tabbedPane = new javax.swing.JTabbedPane();
        generalTab = new javax.swing.JPanel();
        kazuCheck = new javax.swing.JCheckBox();
        ignorekeyCheck = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        
        
        generalTab.setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          
          kazuCheck.setText("Enable Kazu's workaround for bug 51327");
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            generalTab.add(kazuCheck, gridBagConstraints1);
            
            
          ignorekeyCheck.setText("ignore access and command keys in \"unstranslated strings\"");
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
            generalTab.add(ignorekeyCheck, gridBagConstraints1);
            
            tabbedPane.addTab("General", generalTab);
          
          
        getContentPane().add(tabbedPane, java.awt.BorderLayout.CENTER);
        
        
        
        okButton.setText("OK");
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonPressed(evt);
              }
          }
          );
          jPanel1.add(okButton);
          
          
        cancelButton.setText("Cancel");
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonPressed(evt);
              }
          }
          );
          jPanel1.add(cancelButton);
          
          
        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);
        
    }//GEN-END:initComponents

  private void okButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonPressed
    okay=true;
    setVisible(false);
  }//GEN-LAST:event_okButtonPressed

  private void cancelButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonPressed
    okay=false;
    setVisible(false);
  }//GEN-LAST:event_cancelButtonPressed

  
public void visDialog()
{
    
    
    // setup the dialog
    kazuCheck.setSelected(Settings.getBoolean("mozbug.nobackslash",false));
    ignorekeyCheck.setSelected(Settings.getBoolean("unstranslated.ignorekeys",false));
    
   
    // show dialog
    okay=false;
    setVisible(true);
    
    if (okay)
    {
        Settings.setBoolean("mozbug.nobackslash",kazuCheck.isSelected());
        Settings.setBoolean("unstranslated.ignorekeys",ignorekeyCheck.isSelected());
        Settings.save();
    }
    dispose();
}

// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JTabbedPane tabbedPane;
private javax.swing.JPanel generalTab;
private javax.swing.JCheckBox kazuCheck;
private javax.swing.JCheckBox ignorekeyCheck;
private javax.swing.JPanel jPanel1;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
// End of variables declaration//GEN-END:variables
    private boolean okay;
}