/*
 * EditUnknownDialog.java
 *
 * Created on 23. september 2000, 19:46
 */

package org.mozilla.translator.gui.dialog;

import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.kernel.*;
import org.mozilla.translator.gui.*;

/**
 *
 * @author  Henrik Lynggaard
 * @version 
 */
public class EditUnknownDialog extends javax.swing.JDialog {

    private boolean okay;
    
    /** Creates new form EditUnknownDialog */
    public EditUnknownDialog() {
        super (MainWindow.getDefaultInstance(),"Edit Unknown file", true);
        initComponents ();
        pack ();
        Utils.placeFrameAtCenter(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        tabs = new javax.swing.JTabbedPane();
        originalPanel = new javax.swing.JPanel();
        originalScroll = new javax.swing.JScrollPane();
        originalArea = new javax.swing.JTextArea();
        translatedPanel = new javax.swing.JPanel();
        translatedScroll = new javax.swing.JScrollPane();
        translatedArea = new javax.swing.JTextArea();
        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        
        okButton.setText("OK");
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(okButton);
          
          
        cancelButton.setText("Cancel");
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed(evt);
              }
          }
          );
          buttonPanel.add(cancelButton);
          
          
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        
        
        originalPanel.setLayout(new java.awt.BorderLayout());
          
          
            originalArea.setEditable(false);
              originalArea.setColumns(50);
              originalArea.setRows(20);
              originalScroll.setViewportView(originalArea);
              
              originalPanel.add(originalScroll, java.awt.BorderLayout.CENTER);
            
            tabs.addTab("Original text", originalPanel);
          
          
        translatedPanel.setLayout(new java.awt.BorderLayout());
          
          
            translatedArea.setColumns(50);
              translatedArea.setRows(20);
              translatedScroll.setViewportView(translatedArea);
              
              translatedPanel.add(translatedScroll, java.awt.BorderLayout.CENTER);
            
            tabs.addTab("Translated Text", translatedPanel);
          
          
        getContentPane().add(tabs, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

  private void tabSizeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tabSizeButtonActionPerformed
   
  }//GEN-LAST:event_tabSizeButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    okay=false;
    setVisible(false);
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    okay=true;
    setVisible(false);
    
  }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        okay=false;
        setVisible (false);

    }//GEN-LAST:event_closeDialog

    public void visDialog(Phrase ph,String localeName)
    {
        originalArea.setText(ph.getText());
        
        Translation currentTranslation = (Translation) ph.getChildByName(localeName);
        
        if (currentTranslation==null)
        {
            translatedArea.setText(ph.getText());
        }
        else
        {
            translatedArea.setText(currentTranslation.getText());
        }
        pack();
        Utils.placeFrameAtCenter(this);
              
        setVisible(true);
        if (okay)
        {
            if (currentTranslation==null)
            {
                currentTranslation = new Translation(localeName,ph,translatedArea.getText());
                ph.addChild(currentTranslation);
            }
            else
            {
                currentTranslation.setText(translatedArea.getText());
            }
        }
                
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTabbedPane tabs;
    private javax.swing.JPanel originalPanel;
    private javax.swing.JScrollPane originalScroll;
    private javax.swing.JTextArea originalArea;
    private javax.swing.JPanel translatedPanel;
    private javax.swing.JScrollPane translatedScroll;
    private javax.swing.JTextArea translatedArea;
    // End of variables declaration//GEN-END:variables

}
