/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui.dialog;

import java.io.*;
import javax.swing.*;

import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.kernel.*;
/** 
 *
 * @author  Henrik Lynggaard Hansen
 * @version 
 */
public class EditInstallDialog extends javax.swing.JDialog {

  
  /** Creates new form EditInstallDialog */
  public EditInstallDialog(java.awt.Frame parent,MozInstall mzi) {
    super (parent,"Edit Installation",true);
    install=mzi;
    initComponents ();
    getRootPane().setDefaultButton(okButton);
    pack ();
    Utils.placeFrameAtCenter(this);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents() {//GEN-BEGIN:initComponents
      infoPanel = new javax.swing.JPanel();
      nameLabel = new javax.swing.JLabel();
      nameField = new javax.swing.JTextField();
      pathLabel = new javax.swing.JLabel();
      pathField = new javax.swing.JTextField();
      pathButton = new javax.swing.JButton();
      buttonPanel = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      getContentPane().setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints1;
      setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
      addWindowListener(new java.awt.event.WindowAdapter() {
          public void windowClosing(java.awt.event.WindowEvent evt) {
              closeWindow(evt);
          }
      }
      );
      
      infoPanel.setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints2;
      infoPanel.setBorder(new javax.swing.border.TitledBorder(
      new javax.swing.border.EtchedBorder(), "Install Information", 4, 2,
      new java.awt.Font ("Dialog", 0, 10)));
      
      nameLabel.setText("Name");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(3, 3, 0, 0);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        infoPanel.add(nameLabel, gridBagConstraints2);
        
        
      nameField.setColumns(30);
        nameField.setText("Mozilla M16");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new java.awt.Insets(3, 3, 0, 3);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        infoPanel.add(nameField, gridBagConstraints2);
        
        
      pathLabel.setText("Location");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new java.awt.Insets(3, 3, 3, 0);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        infoPanel.add(pathLabel, gridBagConstraints2);
        
        
      pathField.setColumns(30);
        pathField.setText("C:\\program files\\mozilla\\chrome");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new java.awt.Insets(3, 3, 3, 0);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        infoPanel.add(pathField, gridBagConstraints2);
        
        
      pathButton.setToolTipText("Choose directory or jar file for the install");
        pathButton.setText("Choose");
        pathButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pathButtonPressed(evt);
            }
        }
        );
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new java.awt.Insets(3, 3, 3, 3);
        infoPanel.add(pathButton, gridBagConstraints2);
        
        
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(3, 3, 3, 3);
      getContentPane().add(infoPanel, gridBagConstraints1);
      
      
      buttonPanel.setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints3;
      
      okButton.setToolTipText("Leaves and saves the information");
        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonPressed(evt);
            }
        }
        );
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new java.awt.Insets(0, 3, 3, 2);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.NORTHEAST;
        buttonPanel.add(okButton, gridBagConstraints3);
        
        
      cancelButton.setToolTipText("Leaveswithout saving the information");
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonPressed(evt);
            }
        }
        );
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = new java.awt.Insets(0, 2, 3, 3);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.NORTHWEST;
        buttonPanel.add(cancelButton, gridBagConstraints3);
        
        
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(0, 3, 3, 3);
      getContentPane().add(buttonPanel, gridBagConstraints1);
      
  }//GEN-END:initComponents

  private void pathButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pathButtonPressed
   
    File defaultFile = new File(pathField.getText());
    JFileChooser dirChooser = new JFileChooser();
    dirChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
    dirChooser.setDialogTitle("Select directory or jar file for the install");
    dirChooser.setSelectedFile(defaultFile);
    int result = dirChooser.showDialog(this,"Choose");
    if (result==JFileChooser.APPROVE_OPTION)
    {
      File dir = dirChooser.getSelectedFile();
      pathField.setText(dir.toString());
    }    
  }//GEN-LAST:event_pathButtonPressed

  private void closeWindow (java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeWindow
    okay=false;
    setVisible(false);
  }//GEN-LAST:event_closeWindow

  private void cancelButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonPressed
    okay=false;
    setVisible(false);
  }//GEN-LAST:event_cancelButtonPressed

  private void okButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonPressed
    okay=true;
    setVisible(false);
  }//GEN-LAST:event_okButtonPressed

 public boolean visDialog()
 {
  
  nameField.setText(install.getName());
  pathField.setText(install.getPath());
  
  setVisible(true);
  
  if (okay)
  {
    install.setPath(pathField.getText());
    install.setName(nameField.getText());
  }
  dispose();
  return okay;
  }  
  


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel infoPanel;
  private javax.swing.JLabel nameLabel;
  private javax.swing.JTextField nameField;
  private javax.swing.JLabel pathLabel;
  private javax.swing.JTextField pathField;
  private javax.swing.JButton pathButton;
  private javax.swing.JPanel buttonPanel;
  private javax.swing.JButton okButton;
  private javax.swing.JButton cancelButton;
  // End of variables declaration//GEN-END:variables
  private boolean okay;
  private MozInstall install;
}