/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui;

import java.awt.*;
import javax.swing.*;

import org.mozilla.translator.kernel.*;
import org.mozilla.translator.actions.*;

/** 
 *
 * @author  Henrik Lynggaard Hansen
 * @version 4.0
 */
public class MainWindow extends JFrame {

  private static MainWindow instance;
  
  private JLabel statusLine;
  private JDesktopPane desktop;
  private JMenuBar menuBar;
  private JMenu fileMenu;
  //private JMenu glossaryMenu;
  //private JMenu commandMenu;
  //private JMenu viewMenu;
  private JMenu helpMenu;
  private JMenu importMenu;
  private JMenu exportMenu;
  private JMenu editMenu;
  
  
  public  static void init()
  {
    instance = new MainWindow();
  }
  
  public static MainWindow getDefaultInstance()
  {
    return instance;
  }
  
  
  /** Creates new MainWindow */
  private MainWindow() 
  {
    super("MozillaTranslator, Version " + Settings.getString("System.Version","X.xx"));
   
    setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    desktop = new JDesktopPane();
    statusLine = new JLabel("Status: Loading...");
    
    menuBar = new JMenuBar();
/* new menu structure
 *
 */
    fileMenu   = new JMenu("File");
    importMenu = new JMenu("Import");
    exportMenu = new JMenu("Export");
    editMenu   = new JMenu("Edit");
    helpMenu = new JMenu("Help");

    // filemenu
    addMenuItem(fileMenu , new InstallManagerAction());
    addMenuItem(fileMenu , new UpdateInstallAction() );
    addMenuItem(fileMenu , new SaveGlossaryAction() );
    fileMenu.addSeparator();
    addMenuItem(fileMenu , new SetupAction());
    fileMenu.addSeparator();
    QuitAction qaction = new QuitAction();
    addMenuItem(fileMenu , qaction);
    addWindowListener(qaction);

    // import menu
    addMenuItem(importMenu , new ImportPartialGlossaryAction());
    importMenu.addSeparator();
    addMenuItem(importMenu , new ImportLocaleAction());
    importMenu.addSeparator();
    addMenuItem(importMenu , new ImportOldGlossaryAction());
    
    //export menu
    addMenuItem(exportMenu , new ExportPartialGlossaryAction());
    exportMenu.addSeparator();
    addMenuItem(exportMenu , new WritePackageAction());
    addMenuItem(exportMenu , new WriteJarAction()); 
    addMenuItem(exportMenu , new WriteXpiAction()); 
    exportMenu.addSeparator();
    addMenuItem(exportMenu,  new ExportTextAction());      
    
    
    // edit menu
    addMenuItem(editMenu , new ChromeViewAction(), "alt C");
    editMenu.addSeparator();
    addMenuItem(editMenu , new UntranslatedViewAction() , "alt U");
    addMenuItem(editMenu , new RedundantViewAction(), "alt R");
    addMenuItem(editMenu , new KeepViewAction(), "alt K");
    addMenuItem(editMenu , new IndenticalStringAction());
    editMenu.addSeparator();
    addMenuItem(editMenu , new EditPhraseAction(), "alt E");
    editMenu.addSeparator();
    addMenuItem(editMenu , new SearchViewAction(), "alt S");
    addMenuItem(editMenu , new AdvancedSearchAction());
    addMenuItem(editMenu , new KeybindingCheckerAction());

    //help menu
    addMenuItem(helpMenu, new AboutAction());
     
    // add the menus
    menuBar.add(fileMenu);
    menuBar.add(importMenu);
    menuBar.add(exportMenu);
    menuBar.add(editMenu);
    menuBar.add(helpMenu);
    // build the window
    setJMenuBar(menuBar);
    
    getContentPane().add(desktop, BorderLayout.CENTER);
    getContentPane().add(statusLine, BorderLayout.SOUTH);
    
    setSize(800,600);
    Utils.placeFrameAtCenter(this);

  }

  public void setStatus(String text)
  {
    statusLine.setText(text);
  }
  
  public void addWindow(JInternalFrame win)
  {
    desktop.add(win);
  }

  private void addMenuItem(JMenu adMenu,Action action)
  {
      addMenuItem(adMenu,action,null);
  }
  
  private void addMenuItem(JMenu adMenu,Action action,String key)
  {
    JMenuItem item;
    item = adMenu.add(action);
    if (key!=null)
    {
      item.setAccelerator(KeyStroke.getKeyStroke(key));
    }
  }

  public MozFrame getInnerFrame()
  {
    return (MozFrame) desktop.getSelectedFrame();
  }
}
